/*
 * Decompiled with CFR 0.152.
 */
package jclass.image;

import jclass.image.ByteString;
import jclass.image.Node;

class NewLZWHashtable {
    int maxCode;
    int maxCodeSize;
    int nextAvailableCode;
    int initialCodeSize;
    public int currentCodeSize;
    public int endOfInformationCode;
    public int clearCode;
    Node root;

    public NewLZWHashtable(int n, int n2) {
        this.maxCode = (1 << n) - 1;
        this.maxCodeSize = n;
        this.initialCodeSize = n2;
        this.clear();
    }

    public int getCodeForString(ByteString byteString) {
        if (byteString.isEmpty()) {
            throw new IllegalArgumentException("Empty ByteString not allowed");
        }
        Node node = this.root.findByteString(byteString);
        if (node == null) {
            return -1;
        }
        return node.code;
    }

    public boolean isFull() {
        return this.nextAvailableCode > this.maxCode;
    }

    public void addString(ByteString byteString) {
        if (byteString.isEmpty()) {
            return;
        }
        Node node = this.root.addByteString(byteString);
        if (node.code == -1) {
            node.code = this.nextAvailableCode;
            if (this.nextAvailableCode >= (1 << this.currentCodeSize) + 1) {
                ++this.currentCodeSize;
            }
            ++this.nextAvailableCode;
        }
    }

    public void clear() {
        this.currentCodeSize = this.initialCodeSize + 1;
        this.root = new Node();
        this.nextAvailableCode = 0;
        while (this.nextAvailableCode < 1 << this.initialCodeSize) {
            Node node = this.root.addByteString(new ByteString((byte)this.nextAvailableCode));
            node.code = this.nextAvailableCode++;
        }
        this.clearCode = this.nextAvailableCode++;
        this.endOfInformationCode = this.nextAvailableCode++;
    }

    public int numEntries() {
        return this.nextAvailableCode;
    }
}

